package conversions;
import java.awt.*;

public class ForceQuantity extends ObservableQuantity {
	
	private double value;
	
	private int type=0;

	private String units = "pound";

	private boolean metric = false;
	private String name = "";
	
	public boolean isMetric() {
		return metric;
	}
	
	public ForceQuantity(
		double _value, 
		String _name,
		int _type) {
		value = _value;
		name = _name;
		type=_type;
	}
	
	public double getValue() {
		return value;
	}
	
	
	public void setValue(double d) {
		convertToEnglish();
		if (value == d) return;
		value = d;
		setChanged();
		
	}
	public int getType() {
		return type;
	}
	
	public String getUnits() {
		return units;
	}
	public void convertToMetric() {
		if (metric == true) return;
		setChanged();
		metric = true;
		units = "Newton";
		value =
			value * 4.448;
	}
	public String toString() {
		return name+"=" + value + " "+units;
	}
	public void convertToEnglish() {
		if (metric == false) return;
		setChanged();

		metric = false;
		units = "pound";
		value =
			value /4.448;
	}
	
	
	public  void test() {

		System.out.println(this );
		convertToEnglish();
		System.out.println(this );
		convertToMetric();
		System.out.println(this);
	}		
 
		
}